---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：1-エラーページ (_error)

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/pages/_error.tsx` L5-10 - statusCodesマッピング定義
- E-02: `packages/next/src/pages/_error.tsx` L12-17 - ErrorProps型定義
- E-03: `packages/next/src/pages/_error.tsx` L19-43 - _getInitialProps関数
- E-04: `packages/next/src/pages/_error.tsx` L45-76 - styles定義
- E-05: `packages/next/src/pages/_error.tsx` L81-156 - Errorクラス定義
- E-06: `packages/next/src/pages/_error.tsx` L88 - withDarkModeデフォルト値
- E-07: `packages/next/src/pages/_error.tsx` L82 - displayName設定
- E-08: `packages/next/src/pages/_error.tsx` L84-85 - getInitialPropsとorigGetInitialProps
- E-09: `packages/next/src/pages/_error.tsx` L96-102 - Headコンポーネントによるtitle設定
- E-10: `packages/next/src/pages/_error.tsx` L123-127 - ダークモードCSS
- E-11: `packages/next/src/shared/lib/utils.ts` L120-161 - NextPageContext型
- E-12: `docs/code-to-docs/画面一覧/画面一覧.csv` L2 - 画面情報定義
- E-13: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` L2-4 - 関連機能情報
- E-14: `docs/code-to-docs/画面一覧/画面遷移図.md` L13-23 - Pages Router遷移図

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | statusCodesマッピングに400,404,405,500が定義されている | E-01 | ○ |
| C-02 | ErrorPropsはstatusCode,hostname,title,withDarkModeを持つ | E-02 | ○ |
| C-03 | getInitialPropsでres.statusCode→err.statusCode→404の優先順位でstatusCodeを決定 | E-03 | ○ |
| C-04 | サーバーサイドではgetRequestMetaでhostnameを取得 | E-03 | ○ |
| C-05 | クライアントサイドではwindow.location.hostnameを使用 | E-03 | ○ |
| C-06 | 画面中央にFlexboxで配置される | E-04 | ○ |
| C-07 | Errorクラスはreact.Componentを継承 | E-05 | ○ |
| C-08 | withDarkModeのデフォルト値はtrue | E-06 | ○ |
| C-09 | displayNameはErrorPage | E-07 | ○ |
| C-10 | origGetInitialPropsに元の関数が保持される | E-08 | ○ |
| C-11 | Headコンポーネントでtitleを設定する | E-09 | ○ |
| C-12 | ダークモード対応はprefers-color-schemeメディアクエリで実装 | E-10 | ○ |
| C-13 | statusCodeなしの場合「Application error: a client-side exception has occurred」を表示 | E-05 | ○ |
| C-14 | Pages Routerで使用される | E-12 | ○ |
| C-15 | カスタムエラーページ機能が主機能 | E-13 | ○ |
| C-16 | Pages Routerのルーティング機構経由で表示 | E-13, E-14 | ○ |
| C-17 | getInitialPropsによるSSR対応 | E-03, E-13 | ○ |
| C-18 | CSSはインラインスタイルで外部依存なし | E-04, E-10 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] statusCodesマッピングの4種類が正しく記載されているか確認
- [ ] getInitialPropsのフォールバック順序が正確か確認
- [ ] ダークモード対応の記述が実装と一致するか確認
